/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.storage;

import com.cobblemon.mod.common.CobblemonNetwork;
import com.cobblemon.mod.common.api.PrioritizedList;
import com.cobblemon.mod.common.api.Priority;
import com.cobblemon.mod.common.api.storage.NoPokemonStoreException;
import com.cobblemon.mod.common.api.storage.PokemonStore;
import com.cobblemon.mod.common.api.storage.StorePosition;
import com.cobblemon.mod.common.api.storage.factory.PokemonStoreFactory;
import com.cobblemon.mod.common.api.storage.party.PartyStore;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.api.storage.pc.PCStore;
import com.cobblemon.mod.common.block.entity.PCBlockEntity;
import com.cobblemon.mod.common.net.messages.client.storage.party.SetPartyReferencePacket;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.class_3222;
import net.minecraft.class_5455;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u001f\u0010\r\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u000f\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0017\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001f\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0018J\u0017\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u001f\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001cJ!\u0010\u001f\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u001dH\u0016\u00a2\u0006\u0004\b\u001f\u0010 J%\u0010#\u001a\b\u0012\u0004\u0012\u00020\"0!2\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b#\u0010$J%\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00190!2\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b%\u0010$J>\u0010+\u001a\u0004\u0018\u00018\u0001\"\b\b\u0000\u0010'*\u00020&\"\u0010\b\u0001\u0010)\u0018\u0001*\b\u0012\u0004\u0012\u00028\u00000(2\u0006\u0010*\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\u000bH\u0086\b\u00a2\u0006\u0004\b+\u0010,JI\u0010+\u001a\u0004\u0018\u00018\u0001\"\b\b\u0000\u0010'*\u00020&\"\u000e\b\u0001\u0010)*\b\u0012\u0004\u0012\u00028\u00000(2\f\u0010.\u001a\b\u0012\u0004\u0012\u00028\u00010-2\u0006\u0010*\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b+\u0010/J\u0017\u00100\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b0\u00101J\u0017\u00102\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b2\u00101R\u001a\u00104\u001a\b\u0012\u0004\u0012\u00020\u0006038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b4\u00105\u00a8\u00066"}, d2={"Lcom/cobblemon/mod/common/api/storage/PokemonStoreManager;", "", "<init>", "()V", "Lcom/cobblemon/mod/common/api/Priority;", "priority", "Lcom/cobblemon/mod/common/api/storage/factory/PokemonStoreFactory;", "factory", "", "registerFactory", "(Lcom/cobblemon/mod/common/api/Priority;Lcom/cobblemon/mod/common/api/storage/factory/PokemonStoreFactory;)V", "Lnet/minecraft/class_5455;", "registryAccess", "unregisterFactory", "(Lcom/cobblemon/mod/common/api/storage/factory/PokemonStoreFactory;Lnet/minecraft/class_5455;)V", "unregisterAll", "(Lnet/minecraft/class_5455;)V", "Lnet/minecraft/class_3222;", "player", "Lcom/cobblemon/mod/common/api/storage/party/PlayerPartyStore;", "getParty", "(Lnet/minecraft/class_3222;)Lcom/cobblemon/mod/common/api/storage/party/PlayerPartyStore;", "Ljava/util/UUID;", "playerID", "(Ljava/util/UUID;Lnet/minecraft/class_5455;)Lcom/cobblemon/mod/common/api/storage/party/PlayerPartyStore;", "Lcom/cobblemon/mod/common/api/storage/pc/PCStore;", "getPC", "(Lnet/minecraft/class_3222;)Lcom/cobblemon/mod/common/api/storage/pc/PCStore;", "(Ljava/util/UUID;Lnet/minecraft/class_5455;)Lcom/cobblemon/mod/common/api/storage/pc/PCStore;", "Lcom/cobblemon/mod/common/block/entity/PCBlockEntity;", "pcBlockEntity", "getPCForPlayer", "(Lnet/minecraft/class_3222;Lcom/cobblemon/mod/common/block/entity/PCBlockEntity;)Lcom/cobblemon/mod/common/api/storage/pc/PCStore;", "", "Lcom/cobblemon/mod/common/api/storage/party/PartyStore;", "getParties", "(Ljava/util/UUID;Lnet/minecraft/class_5455;)Ljava/lang/Iterable;", "getPCs", "Lcom/cobblemon/mod/common/api/storage/StorePosition;", "E", "Lcom/cobblemon/mod/common/api/storage/PokemonStore;", "T", "uuid", "getCustomStore", "(Ljava/util/UUID;Lnet/minecraft/class_5455;)Lcom/cobblemon/mod/common/api/storage/PokemonStore;", "Ljava/lang/Class;", "storeClass", "(Ljava/lang/Class;Ljava/util/UUID;Lnet/minecraft/class_5455;)Lcom/cobblemon/mod/common/api/storage/PokemonStore;", "onPlayerDataSync", "(Lnet/minecraft/class_3222;)V", "onPlayerDisconnect", "Lcom/cobblemon/mod/common/api/PrioritizedList;", "factories", "Lcom/cobblemon/mod/common/api/PrioritizedList;", "common"})
@SourceDebugExtension(value={"SMAP\nPokemonStoreManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PokemonStoreManager.kt\ncom/cobblemon/mod/common/api/storage/PokemonStoreManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,111:1\n1869#2,2:112\n1869#2,2:115\n1869#2,2:117\n1#3:114\n*S KotlinDebug\n*F\n+ 1 PokemonStoreManager.kt\ncom/cobblemon/mod/common/api/storage/PokemonStoreManager\n*L\n46#1:112,2\n101#1:115,2\n102#1:117,2\n*E\n"})
public class PokemonStoreManager {
    @NotNull
    private final PrioritizedList<PokemonStoreFactory> factories = new PrioritizedList();

    public void registerFactory(@NotNull Priority priority, @NotNull PokemonStoreFactory factory) {
        Intrinsics.checkNotNullParameter((Object)((Object)priority), (String)"priority");
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        this.factories.add(priority, factory);
    }

    public void unregisterFactory(@NotNull PokemonStoreFactory factory, @NotNull class_5455 registryAccess) {
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        Intrinsics.checkNotNullParameter((Object)registryAccess, (String)"registryAccess");
        factory.shutdown(registryAccess);
        this.factories.remove(factory);
    }

    public void unregisterAll(@NotNull class_5455 registryAccess) {
        Intrinsics.checkNotNullParameter((Object)registryAccess, (String)"registryAccess");
        Iterable $this$forEach$iv = CollectionsKt.toList((Iterable)this.factories);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PokemonStoreFactory it = (PokemonStoreFactory)element$iv;
            boolean bl = false;
            this.unregisterFactory(it, registryAccess);
        }
    }

    @NotNull
    public PlayerPartyStore getParty(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        UUID uUID = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        class_5455 class_54552 = player.method_56673();
        Intrinsics.checkNotNullExpressionValue((Object)class_54552, (String)"registryAccess(...)");
        return this.getParty(uUID, class_54552);
    }

    @NotNull
    public PlayerPartyStore getParty(@NotNull UUID playerID, @NotNull class_5455 registryAccess) {
        PlayerPartyStore playerPartyStore;
        block2: {
            Intrinsics.checkNotNullParameter((Object)playerID, (String)"playerID");
            Intrinsics.checkNotNullParameter((Object)registryAccess, (String)"registryAccess");
            for (PokemonStoreFactory it : (Iterable)this.factories) {
                boolean bl = false;
                PlayerPartyStore playerPartyStore2 = it.getPlayerParty(playerID, registryAccess);
                if (playerPartyStore2 == null) continue;
                playerPartyStore = playerPartyStore2;
                break block2;
            }
            playerPartyStore = null;
        }
        if (playerPartyStore == null) {
            throw new NoPokemonStoreException("No factory was able to provide a party for " + playerID + " - this should not be possible unless someone has removed the default provider!");
        }
        return playerPartyStore;
    }

    @NotNull
    public PCStore getPC(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        UUID uUID = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        class_5455 class_54552 = player.method_56673();
        Intrinsics.checkNotNullExpressionValue((Object)class_54552, (String)"registryAccess(...)");
        return this.getPC(uUID, class_54552);
    }

    @NotNull
    public PCStore getPC(@NotNull UUID playerID, @NotNull class_5455 registryAccess) {
        PCStore pCStore;
        block2: {
            Intrinsics.checkNotNullParameter((Object)playerID, (String)"playerID");
            Intrinsics.checkNotNullParameter((Object)registryAccess, (String)"registryAccess");
            for (PokemonStoreFactory it : (Iterable)this.factories) {
                boolean bl = false;
                PCStore pCStore2 = it.getPC(playerID, registryAccess);
                if (pCStore2 == null) continue;
                pCStore = pCStore2;
                break block2;
            }
            pCStore = null;
        }
        if (pCStore == null) {
            throw new NoPokemonStoreException("No factory was able to provide a PC for " + playerID + " - this should not be possible unless someone has removed the default provider!");
        }
        return pCStore;
    }

    @Nullable
    public PCStore getPCForPlayer(@NotNull class_3222 player, @NotNull PCBlockEntity pcBlockEntity) {
        PCStore pCStore;
        block1: {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Intrinsics.checkNotNullParameter((Object)((Object)pcBlockEntity), (String)"pcBlockEntity");
            for (PokemonStoreFactory it : (Iterable)this.factories) {
                boolean bl = false;
                PCStore pCStore2 = it.getPCForPlayer(player, pcBlockEntity);
                if (pCStore2 == null) continue;
                pCStore = pCStore2;
                break block1;
            }
            pCStore = null;
        }
        return pCStore;
    }

    @NotNull
    public Iterable<PartyStore> getParties(@NotNull UUID playerID, @NotNull class_5455 registryAccess) {
        Intrinsics.checkNotNullParameter((Object)playerID, (String)"playerID");
        Intrinsics.checkNotNullParameter((Object)registryAccess, (String)"registryAccess");
        List parties = new ArrayList();
        Iterator<PokemonStoreFactory> iterator = this.factories.iterator();
        while (iterator.hasNext()) {
            PlayerPartyStore it;
            PokemonStoreFactory factory;
            Intrinsics.checkNotNullExpressionValue((Object)iterator.next(), (String)"next(...)");
            if (factory.getPlayerParty(playerID, registryAccess) == null) continue;
            boolean bl = false;
            parties.add(it);
        }
        return parties;
    }

    @NotNull
    public Iterable<PCStore> getPCs(@NotNull UUID playerID, @NotNull class_5455 registryAccess) {
        Intrinsics.checkNotNullParameter((Object)playerID, (String)"playerID");
        Intrinsics.checkNotNullParameter((Object)registryAccess, (String)"registryAccess");
        List pcs = new ArrayList();
        Iterator<PokemonStoreFactory> iterator = this.factories.iterator();
        while (iterator.hasNext()) {
            PCStore it;
            PokemonStoreFactory factory;
            Intrinsics.checkNotNullExpressionValue((Object)iterator.next(), (String)"next(...)");
            if (factory.getPC(playerID, registryAccess) == null) continue;
            boolean bl = false;
            pcs.add(it);
        }
        return pcs;
    }

    public final /* synthetic */ <E extends StorePosition, T extends PokemonStore<E>> T getCustomStore(UUID uuid, class_5455 registryAccess) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        Intrinsics.checkNotNullParameter((Object)registryAccess, (String)"registryAccess");
        boolean $i$f$getCustomStore = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        return (T)this.getCustomStore(PokemonStore.class, uuid, registryAccess);
    }

    @Nullable
    public <E extends StorePosition, T extends PokemonStore<E>> T getCustomStore(@NotNull Class<T> storeClass, @NotNull UUID uuid, @NotNull class_5455 registryAccess) {
        Intrinsics.checkNotNullParameter(storeClass, (String)"storeClass");
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        Intrinsics.checkNotNullParameter((Object)registryAccess, (String)"registryAccess");
        Iterator<PokemonStoreFactory> iterator = this.factories.iterator();
        while (iterator.hasNext()) {
            PokemonStoreFactory factory;
            Intrinsics.checkNotNullExpressionValue((Object)iterator.next(), (String)"next(...)");
            T t = factory.getCustomStore(storeClass, uuid, registryAccess);
            if (t == null) continue;
            T $this$getCustomStore_u24lambda_u240 = t;
            boolean bl = false;
            return $this$getCustomStore_u24lambda_u240;
        }
        return null;
    }

    public void onPlayerDataSync(@NotNull class_3222 player) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        UUID uUID = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        class_5455 class_54552 = player.method_56673();
        Intrinsics.checkNotNullExpressionValue((Object)class_54552, (String)"registryAccess(...)");
        Iterable<PartyStore> parties = this.getParties(uUID, class_54552);
        Iterable<PokemonStore> $this$forEach$iv = parties;
        boolean $i$f$forEach = false;
        Iterator<PokemonStore> iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            PartyStore partyStore;
            PartyStore party = partyStore = iterator.next();
            bl = false;
            party.sendTo(player);
        }
        UUID uUID2 = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID2, (String)"getUUID(...)");
        class_5455 class_54553 = player.method_56673();
        Intrinsics.checkNotNullExpressionValue((Object)class_54553, (String)"registryAccess(...)");
        $this$forEach$iv = this.getPCs(uUID2, class_54553);
        $i$f$forEach = false;
        for (PokemonStore pokemonStore : $this$forEach$iv) {
            PCStore pc = (PCStore)pokemonStore;
            bl = false;
            pc.sendTo(player);
        }
        CobblemonNetwork.INSTANCE.sendPacket(player, new SetPartyReferencePacket(((PartyStore)CollectionsKt.first(parties)).getUuid()));
    }

    public void onPlayerDisconnect(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Iterator<PokemonStoreFactory> iterator = this.factories.iterator();
        while (iterator.hasNext()) {
            PokemonStoreFactory factory;
            Intrinsics.checkNotNullExpressionValue((Object)iterator.next(), (String)"next(...)");
            factory.onPlayerDisconnect(player);
        }
    }
}

